// MIT License: https://opensource.org/licenses/MIT

in vec2 texCoord;

uniform float iTime;

uniform sampler2D colorMap;
uniform sampler2D paletteMap;

uniform float rpalettes[5];
uniform float radialxs[5];
uniform float radialys[5];

uniform int radialcount;

//========================================================================

const float eps = 0.0000001;


vec3 hsv2rgb( in vec3 c )
{
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
    return c.z * mix( vec3(1.0), rgb, c.y);
}

vec3 hsl2rgb( in vec3 c )
{
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
    return c.z + c.y * (rgb-0.5)*(1.0-abs(2.0*c.z-1.0));
}

vec3 rgb2hsv( in vec3 c)
{
    vec4 k = vec4(0.0, -1.0/3.0, 2.0/3.0, -1.0);
    vec4 p = mix(vec4(c.zy, k.wz), vec4(c.yz, k.xy), (c.z<c.y) ? 1.0 : 0.0);
    vec4 q = mix(vec4(p.xyw, c.x), vec4(c.x, p.yzx), (p.x<c.x) ? 1.0 : 0.0);
    float d = q.x - min(q.w, q.y);
    return vec3(abs(q.z + (q.w - q.y) / (6.0*d+eps)), d / (q.x+eps), q.x);
}

vec3 rgb2hsl( vec3 col )
{
    float minc = min( col.r, min(col.g, col.b) );
    float maxc = max( col.r, max(col.g, col.b) );
    vec3  mask = step(col.grr,col.rgb) * step(col.bbg,col.rgb);
    vec3 h = mask * (vec3(0.0,2.0,4.0) + (col.gbr-col.brg)/(maxc-minc + eps)) / 6.0;
    return vec3( fract( 1.0 + h.x + h.y + h.z ),              // H
                 (maxc-minc)/(1.0-abs(minc+maxc-1.0) + eps),  // S
                 (minc+maxc)*0.5 );                           // L
}

//========================================================================

void main (void)
{
vec4 col = vec4(0.0,0.0,0.0,0.0);
for (int i=0;i<radialcount;i++){
    float index = texture2D(colorMap, texCoord+vec2(radialxs[i],radialys[i])).r;
    vec4 col2 = texture2D(paletteMap, vec2(index,rpalettes[i]));
    col+=col2;
}
col/=float(radialcount);
col.a=1.0;
    //gl_FragColor = texture2D(colorMap, texCoord);
    gl_FragColor = col;
}
